/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.systems.modules.modules.other;

import Krasnodar.rockstarnew.framework.base.CustomComponent;
import Krasnodar.rockstarnew.framework.base.CustomDrawContext;
import Krasnodar.rockstarnew.framework.base.UIContext;
import Krasnodar.rockstarnew.framework.objects.BorderRadius;
import Krasnodar.rockstarnew.framework.objects.MouseButton;
import Krasnodar.rockstarnew.framework.objects.gradient.impl.VerticalGradient;
import Krasnodar.rockstarnew.mixin.accessors.HandledScreenAccessor;
import Krasnodar.rockstarnew.systems.event.EventListener;
import Krasnodar.rockstarnew.systems.event.impl.render.HudRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.render.ScreenRenderEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.ContainerClickEvent;
import Krasnodar.rockstarnew.systems.event.impl.window.ContainerReleaseEvent;
import Krasnodar.rockstarnew.systems.modules.api.ModuleCategory;
import Krasnodar.rockstarnew.systems.modules.api.ModuleInfo;
import Krasnodar.rockstarnew.systems.modules.impl.BaseModule;
import Krasnodar.rockstarnew.systems.setting.Setting;
import Krasnodar.rockstarnew.systems.setting.SettingsContainer;
import Krasnodar.rockstarnew.systems.setting.settings.SelectSetting;
import Krasnodar.rockstarnew.ui.components.popup.Popup;
import Krasnodar.rockstarnew.ui.menu.dropdown.components.settings.impl.SelectSettingComponent;
import Krasnodar.rockstarnew.utility.colors.ColorRGBA;
import Krasnodar.rockstarnew.utility.gui.GuiUtility;
import Krasnodar.rockstarnew.utility.inventory.EnchantmentUtility;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1810;
import net.minecraft.class_1812;
import net.minecraft.class_1836;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_5321;

@ModuleInfo(name="Auction", category=ModuleCategory.OTHER)
public class Auction
extends BaseModule {
    private final List<AuctionItem> pageItems = new ArrayList<AuctionItem>();
    private double averageEffectivePrice = 0.0;
    private double minEffectivePrice = Double.MAX_VALUE;
    private String title = "";
    private final SelectSetting armor = new SelectSetting((SettingsContainer)this, "modules.settings.auction.armor", () -> this.title.toLowerCase().contains("\u043a\u0438\u0440\u043a\u0430") || this.title.toLowerCase().contains("\u0441\u0438\u043b\u044b") || this.title.toLowerCase().contains("\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438"));
    private final SelectSetting.Value noSpike = new SelectSetting.Value(this.armor, "modules.settings.auction.armor.no_spike").select();
    private final SelectSetting.Value noProt5 = new SelectSetting.Value(this.armor, "modules.settings.auction.armor.no_prot5").select();
    private final SelectSetting.Value noDurability = new SelectSetting.Value(this.armor, "modules.settings.auction.armor.no_durability");
    private final SelectSetting.Value noRepair = new SelectSetting.Value(this.armor, "modules.settings.auction.armor.no_repair");
    private final SelectSetting pickaxe = new SelectSetting((SettingsContainer)this, "modules.settings.auction.pickaxe", () -> this.title.toLowerCase().contains("\u0448\u043b\u0435\u043c") || this.title.toLowerCase().contains("\u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a") || this.title.toLowerCase().contains("\u043f\u043e\u043d\u043e\u0436\u0438") || this.title.toLowerCase().contains("\u0431\u043e\u0442\u0438\u043d\u043a\u0438") || this.title.toLowerCase().contains("\u0431\u0440\u043e\u043d\u044f") || this.title.toLowerCase().contains("\u0441\u0438\u043b\u044b") || this.title.toLowerCase().contains("\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u0438"));
    private final SelectSetting.Value noSilkTouch = new SelectSetting.Value(this.pickaxe, "modules.settings.auction.pickaxe.silk_touch");
    private final SelectSetting potions = new SelectSetting((SettingsContainer)this, "modules.settings.auction.potions", () -> this.title.toLowerCase().contains("\u0448\u043b\u0435\u043c") || this.title.toLowerCase().contains("\u043d\u0430\u0433\u0440\u0443\u0434\u043d\u0438\u043a") || this.title.toLowerCase().contains("\u043f\u043e\u043d\u043e\u0436\u0438") || this.title.toLowerCase().contains("\u0431\u043e\u0442\u0438\u043d\u043a\u0438") || this.title.toLowerCase().contains("\u0431\u0440\u043e\u043d\u044f") || this.title.toLowerCase().contains("\u043a\u0438\u0440\u043a\u0430"));
    private final SelectSetting.Value noLevel3 = new SelectSetting.Value(this.potions, "modules.settings.auction.potions.no_level3");
    private final SelectSetting.Value noCombined = new SelectSetting.Value(this.potions, "modules.settings.auction.potions.no_combined");
    private final Popup popup = new Popup(0.0f, 0.0f);
    private final EventListener<HudRenderEvent> onHud = event -> {
        if (Auction.mc.field_1755 == null) {
            this.title = "";
            this.popup.setShowing(false);
            if (this.popup.getAnimation().getValue() > 0.0f) {
                this.drawPopup(event.getContext());
            }
        }
    };
    private final EventListener<ScreenRenderEvent> onScreen = event -> {
        class_465 screen;
        class_437 patt0$temp;
        if (!this.pageItems.isEmpty() && (patt0$temp = Auction.mc.field_1755) instanceof class_465 && this.isAuction((screen = (class_465)patt0$temp).method_25440().getString())) {
            this.popup.setShowing(true);
            HandledScreenAccessor accessor = (HandledScreenAccessor)screen;
            try {
                for (AuctionItem item : this.pageItems) {
                    class_1735 slotToHighlight;
                    if (item.effectivePrice > this.averageEffectivePrice || (slotToHighlight = screen.method_17577().method_7611(item.slotId)) == null) continue;
                    int x = accessor.getX() + slotToHighlight.field_7873;
                    int y = accessor.getY() + slotToHighlight.field_7872;
                    ColorRGBA color = this.calculateHighlightColor(item.effectivePrice);
                    event.getContext().drawRoundedRect((float)x, (float)y, 16.0f, 16.0f, BorderRadius.all(1.0f), new VerticalGradient(color.withAlpha(0.0f), color.withAlpha(0.8f * color.getAlpha())));
                }
            }
            catch (Exception var10) {
                this.reset();
            }
            this.drawPopup(event.getContext());
        }
    };
    private final EventListener<ContainerClickEvent> onClick = event -> this.popup.onMouseClicked(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));
    private final EventListener<ContainerReleaseEvent> onRelease = event -> this.popup.onMouseReleased(event.getX(), event.getY(), MouseButton.fromButtonIndex(event.getButton()));

    public Auction() {
        for (Setting setting : this.getSettings()) {
            if (!(setting instanceof SelectSetting)) continue;
            SelectSetting selectSetting = (SelectSetting)setting;
            this.popup.add(new SelectSettingComponent(selectSetting, (CustomComponent)this.popup));
        }
    }

    @Override
    public void tick() {
        class_437 class_4372 = Auction.mc.field_1755;
        if (class_4372 instanceof class_465) {
            String var3;
            class_465 screen = (class_465)class_4372;
            this.title = var3 = screen.method_25440().getString();
            if (!this.isAuction(var3)) {
                this.reset();
            } else {
                this.scanAndAnalyzePage(screen);
                super.tick();
            }
        } else {
            this.reset();
        }
    }

    private void drawPopup(CustomDrawContext orig) {
        UIContext context = UIContext.of(orig, Auction.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32118(), Auction.mc.field_1755 == null ? -1 : (int)GuiUtility.getMouse().method_32119(), class_310.method_1551().method_61966().method_60637(false));
        this.popup.setWidth(120.0f);
        this.popup.pos(10.0f, sr.getScaledHeight() / 2.0f - this.popup.getHeight() / 2.0f);
        this.popup.render(context);
    }

    private ColorRGBA calculateHighlightColor(double effectivePrice) {
        double range = this.averageEffectivePrice - this.minEffectivePrice;
        double factor = range > 0.0 ? (effectivePrice - this.minEffectivePrice) / range : 0.0;
        factor = Math.max(0.0, Math.min(1.0, factor));
        int red = (int)(60.0 + 195.0 * factor);
        return new ColorRGBA(factor < (double)0.001f ? (float)red : 255.0f, 255.0f, 60.0f, (float)(250.0 * (1.0 - factor)));
    }

    private boolean isAuction(String title) {
        return title.toLowerCase().contains("\u0430\u0443\u043a\u0446\u0438\u043e\u043d") || title.toLowerCase().contains("\u043f\u043e\u0438\u0441\u043a") || title.toLowerCase().contains("\u0431\u0438\u0440\u0436\u0430");
    }

    @Override
    public void onDisable() {
        this.reset();
        super.onDisable();
    }

    private boolean shouldHideItem(class_1799 stack, List<class_2561> tooltip) {
        class_1792 item = stack.method_7909();
        if (item instanceof class_1738) {
            if (this.noSpike.isSelected() && EnchantmentUtility.hasEnchantments(stack, class_1893.field_9097)) {
                return true;
            }
            if (this.noProt5.isSelected() && EnchantmentUtility.getEnchantmentLevel(stack, (class_5321<class_1887>)class_1893.field_9111) < 5) {
                return true;
            }
            if (this.noDurability.isSelected() && stack.method_7936() > 0 && stack.method_7986()) {
                return true;
            }
            if (this.noRepair.isSelected() && !EnchantmentUtility.hasEnchantments(stack, class_1893.field_9101)) {
                return true;
            }
        }
        if (item instanceof class_1810 && this.noSilkTouch.isSelected() && !EnchantmentUtility.hasEnchantments(stack, class_1893.field_9099)) {
            return true;
        }
        if (item instanceof class_1812) {
            List<String> tooltipStrings = tooltip.stream().map(text -> text.getString().toLowerCase()).toList();
            if (this.noLevel3.isSelected() && !this.hasLevel3Potion(tooltipStrings)) {
                return true;
            }
            if (this.noCombined.isSelected() && !this.isCombinedPotion(tooltipStrings)) {
                return true;
            }
        }
        return false;
    }

    private boolean hasLevel3Potion(List<String> tooltip) {
        for (String line : tooltip) {
            if (!line.contains("\u0441\u0438\u043b\u0430") && !line.contains("\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c") || !line.contains("iii") && !line.contains("3") && !line.contains("\u0443\u0441\u0438\u043b\u0435\u043d\u043d")) continue;
            return true;
        }
        return false;
    }

    private boolean isCombinedPotion(List<String> tooltip) {
        boolean hasStrength = tooltip.stream().anyMatch(line -> line.contains("\u0441\u0438\u043b\u0430"));
        boolean hasSpeed = tooltip.stream().anyMatch(line -> line.contains("\u0441\u043a\u043e\u0440\u043e\u0441\u0442\u044c"));
        return hasStrength && hasSpeed;
    }

    private void scanAndAnalyzePage(class_465<?> screen) {
        this.pageItems.clear();
        this.minEffectivePrice = Double.MAX_VALUE;
        double totalEffectivePrice = 0.0;
        int pricedItemCount = 0;
        int containerSize = screen.method_17577().field_7761.size() - 36;
        for (int i = 0; i < containerSize; ++i) {
            List tooltip;
            class_1799 stack;
            class_1735 slot = screen.method_17577().method_7611(i);
            if (slot == null || !slot.method_7681() || this.shouldHideItem(stack = slot.method_7677(), tooltip = stack.method_7950(class_1792.class_9635.method_59528((class_1937)Auction.mc.field_1687), (class_1657)Auction.mc.field_1724, (class_1836)(Auction.mc.field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070)))) continue;
            long totalPrice = -1L;
            for (class_2561 lineText : tooltip) {
                String line = lineText.getString();
                if (!line.contains("\u0426\u0435\u043d\u0430") && !line.contains("\u0426e\u043d\u0430") && !line.contains("\u0426\u0435\u043da") && !line.contains("\u0426e\u043da") && !line.contains("\u041a\u0443\u0440\u0441")) continue;
                try {
                    String priceString = line.replaceAll("[^\\d]", "");
                    if (priceString.isEmpty()) break;
                    totalPrice = Long.parseLong(priceString);
                }
                catch (NumberFormatException priceString) {}
                break;
            }
            if (totalPrice == -1L) continue;
            int count = stack.method_7947();
            int maxDurability = stack.method_7936();
            int currentDurability = maxDurability - stack.method_7919();
            double pricePerUnit = (double)totalPrice / (double)count;
            double durabilityFactor = 1.0;
            if (maxDurability > 0) {
                durabilityFactor = (double)currentDurability / (double)maxDurability;
                durabilityFactor = Math.max(0.1, durabilityFactor);
            }
            double effectivePrice = pricePerUnit / durabilityFactor;
            this.pageItems.add(new AuctionItem(slot.field_7874, totalPrice, count, maxDurability, currentDurability, effectivePrice));
            totalEffectivePrice += effectivePrice;
            ++pricedItemCount;
            if (!(effectivePrice < this.minEffectivePrice)) continue;
            this.minEffectivePrice = effectivePrice;
        }
        if (pricedItemCount > 0) {
            this.averageEffectivePrice = totalEffectivePrice / (double)pricedItemCount;
        } else {
            this.reset();
        }
    }

    private void reset() {
        this.pageItems.clear();
        this.averageEffectivePrice = 0.0;
        this.minEffectivePrice = Double.MAX_VALUE;
    }

    private record AuctionItem(int slotId, long totalPrice, int count, int maxDurability, int currentDurability, double effectivePrice) {
    }
}

